package main

import (
	"fmt"
	"sync"
)

/*
1. Utwórz funkcję uruchamiającą trzy goprocedury komunikujące się za pomocą kanału. Dwie pierwsze goprocedury zapisują po 10 liczb w kanale, natomiast trzecia odczytuje wszystkie liczby z kanału i wyświetla je. Funkcja powinna zakończyć działanie po wyświetleniu wszystkich liczb. Upewnij się, że żadna goprocedura nie przecieka. Jeżeli zachodzi potrzeba, możesz utworzyć dodatkowe goprocedury.
*/

func ProcessData() {
	ch := make(chan int)
	// Użycie dwóch struktur WaitGroup!
	// Pierwsza określa, kiedy ma być zamknięty kanał
	var wg sync.WaitGroup
	wg.Add(2)
	go func() {
		defer wg.Done()
		for i := 0; i < 10; i++ {
			ch <- i
		}
	}()
	go func() {
		defer wg.Done()
		for i := 0; i < 10; i++ {
			ch <- i*100 + 1
		}
	}()
	// Uruchomienie tej pomocniczej goprocedury w celu zamknięcia kanału, po zakończeniu działania obu goprocedur
	go func() {
		wg.Wait()
		close(ch)
	}()
	// Druga struktura WaitGroup określa, kiedy działanie zakończy goprocedura odczytująca dane
	var wg2 sync.WaitGroup
	wg2.Add(1)
	go func() {
		defer wg2.Done()
		for v := range ch {
			fmt.Println(v)
		}
	}()
	wg2.Wait()
}

func main() {
	ProcessData()
}
